# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .accessibility import Accessibility


class OpenapiOption(object):
    _types = {
        "http_method": str,
        "url_pattern": str,
        "accessibility": Accessibility,
    }

    def __init__(self, d=None):
        self.http_method: Optional[str] = None
        self.url_pattern: Optional[str] = None
        self.accessibility: Optional[Accessibility] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OpenapiOptionBuilder":
        return OpenapiOptionBuilder()


class OpenapiOptionBuilder(object):
    def __init__(self) -> None:
        self._openapi_option = OpenapiOption()

    def http_method(self, http_method: str) -> "OpenapiOptionBuilder":
        self._openapi_option.http_method = http_method
        return self

    def url_pattern(self, url_pattern: str) -> "OpenapiOptionBuilder":
        self._openapi_option.url_pattern = url_pattern
        return self

    def accessibility(self, accessibility: Accessibility) -> "OpenapiOptionBuilder":
        self._openapi_option.accessibility = accessibility
        return self

    def build(self) -> "OpenapiOption":
        return self._openapi_option
