# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .patch_application_visibility_request_body import PatchApplicationVisibilityRequestBody


class PatchApplicationVisibilityRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.department_id_type: Optional[str] = None
        self.user_id_type: Optional[str] = None
        self.app_id: Optional[str] = None
        self.request_body: Optional[PatchApplicationVisibilityRequestBody] = None

    @staticmethod
    def builder() -> "PatchApplicationVisibilityRequestBuilder":
        return PatchApplicationVisibilityRequestBuilder()


class PatchApplicationVisibilityRequestBuilder(object):

    def __init__(self) -> None:
        patch_application_visibility_request = PatchApplicationVisibilityRequest()
        patch_application_visibility_request.http_method = HttpMethod.PATCH
        patch_application_visibility_request.uri = "/open-apis/application/v6/applications/:app_id/visibility"
        patch_application_visibility_request.token_types = {AccessTokenType.TENANT}
        self._patch_application_visibility_request: PatchApplicationVisibilityRequest = patch_application_visibility_request

    def department_id_type(self, department_id_type: str) -> "PatchApplicationVisibilityRequestBuilder":
        self._patch_application_visibility_request.department_id_type = department_id_type
        self._patch_application_visibility_request.add_query("department_id_type", department_id_type)
        return self

    def user_id_type(self, user_id_type: str) -> "PatchApplicationVisibilityRequestBuilder":
        self._patch_application_visibility_request.user_id_type = user_id_type
        self._patch_application_visibility_request.add_query("user_id_type", user_id_type)
        return self

    def app_id(self, app_id: str) -> "PatchApplicationVisibilityRequestBuilder":
        self._patch_application_visibility_request.app_id = app_id
        self._patch_application_visibility_request.paths["app_id"] = str(app_id)
        return self

    def request_body(self,
                     request_body: PatchApplicationVisibilityRequestBody) -> "PatchApplicationVisibilityRequestBuilder":
        self._patch_application_visibility_request.request_body = request_body
        self._patch_application_visibility_request.body = request_body
        return self

    def build(self) -> PatchApplicationVisibilityRequest:
        return self._patch_application_visibility_request
