# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .app_visibility_id_list import AppVisibilityIdList


class PatchApplicationVisibilityRequestBody(object):
    _types = {
        "add_visible_list": AppVisibilityIdList,
        "del_visible_list": AppVisibilityIdList,
        "add_invisible_list": AppVisibilityIdList,
        "del_invisible_list": AppVisibilityIdList,
        "is_visible_to_all": bool,
    }

    def __init__(self, d=None):
        self.add_visible_list: Optional[AppVisibilityIdList] = None
        self.del_visible_list: Optional[AppVisibilityIdList] = None
        self.add_invisible_list: Optional[AppVisibilityIdList] = None
        self.del_invisible_list: Optional[AppVisibilityIdList] = None
        self.is_visible_to_all: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PatchApplicationVisibilityRequestBodyBuilder":
        return PatchApplicationVisibilityRequestBodyBuilder()


class PatchApplicationVisibilityRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._patch_application_visibility_request_body = PatchApplicationVisibilityRequestBody()

    def add_visible_list(self, add_visible_list: AppVisibilityIdList) -> "PatchApplicationVisibilityRequestBodyBuilder":
        self._patch_application_visibility_request_body.add_visible_list = add_visible_list
        return self

    def del_visible_list(self, del_visible_list: AppVisibilityIdList) -> "PatchApplicationVisibilityRequestBodyBuilder":
        self._patch_application_visibility_request_body.del_visible_list = del_visible_list
        return self

    def add_invisible_list(self,
                           add_invisible_list: AppVisibilityIdList) -> "PatchApplicationVisibilityRequestBodyBuilder":
        self._patch_application_visibility_request_body.add_invisible_list = add_invisible_list
        return self

    def del_invisible_list(self,
                           del_invisible_list: AppVisibilityIdList) -> "PatchApplicationVisibilityRequestBodyBuilder":
        self._patch_application_visibility_request_body.del_invisible_list = del_invisible_list
        return self

    def is_visible_to_all(self, is_visible_to_all: bool) -> "PatchApplicationVisibilityRequestBodyBuilder":
        self._patch_application_visibility_request_body.is_visible_to_all = is_visible_to_all
        return self

    def build(self) -> "PatchApplicationVisibilityRequestBody":
        return self._patch_application_visibility_request_body
