# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .app_badge import AppBadge


class SetAppBadgeRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[AppBadge] = None

    @staticmethod
    def builder() -> "SetAppBadgeRequestBuilder":
        return SetAppBadgeRequestBuilder()


class SetAppBadgeRequestBuilder(object):

    def __init__(self) -> None:
        set_app_badge_request = SetAppBadgeRequest()
        set_app_badge_request.http_method = HttpMethod.POST
        set_app_badge_request.uri = "/open-apis/application/v6/app_badge/set"
        set_app_badge_request.token_types = {AccessTokenType.TENANT}
        self._set_app_badge_request: SetAppBadgeRequest = set_app_badge_request

    def user_id_type(self, user_id_type: str) -> "SetAppBadgeRequestBuilder":
        self._set_app_badge_request.user_id_type = user_id_type
        self._set_app_badge_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: AppBadge) -> "SetAppBadgeRequestBuilder":
        self._set_app_badge_request.request_body = request_body
        self._set_app_badge_request.body = request_body
        return self

    def build(self) -> SetAppBadgeRequest:
        return self._set_app_badge_request
