# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.department_overview_application_app_usage_request import DepartmentOverviewApplicationAppUsageRequest
from ..model.department_overview_application_app_usage_response import DepartmentOverviewApplicationAppUsageResponse
from ..model.overview_application_app_usage_request import OverviewApplicationAppUsageRequest
from ..model.overview_application_app_usage_response import OverviewApplicationAppUsageResponse


class ApplicationAppUsage(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def department_overview(self, request: DepartmentOverviewApplicationAppUsageRequest,
                            option: Optional[RequestOption] = None) -> DepartmentOverviewApplicationAppUsageResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DepartmentOverviewApplicationAppUsageResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                                 DepartmentOverviewApplicationAppUsageResponse)
        response.raw = resp

        return response

    async def adepartment_overview(self, request: DepartmentOverviewApplicationAppUsageRequest, option: Optional[
        RequestOption] = None) -> DepartmentOverviewApplicationAppUsageResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DepartmentOverviewApplicationAppUsageResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                                 DepartmentOverviewApplicationAppUsageResponse)
        response.raw = resp

        return response

    def overview(self, request: OverviewApplicationAppUsageRequest,
                 option: Optional[RequestOption] = None) -> OverviewApplicationAppUsageResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: OverviewApplicationAppUsageResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                       OverviewApplicationAppUsageResponse)
        response.raw = resp

        return response

    async def aoverview(self, request: OverviewApplicationAppUsageRequest,
                        option: Optional[RequestOption] = None) -> OverviewApplicationAppUsageResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: OverviewApplicationAppUsageResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                       OverviewApplicationAppUsageResponse)
        response.raw = resp

        return response
