# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.contacts_range_suggest_application_app_version_request import \
    ContactsRangeSuggestApplicationAppVersionRequest
from ..model.contacts_range_suggest_application_app_version_response import \
    ContactsRangeSuggestApplicationAppVersionResponse
from ..model.get_application_app_version_request import GetApplicationAppVersionRequest
from ..model.get_application_app_version_response import GetApplicationAppVersionResponse
from ..model.list_application_app_version_request import ListApplicationAppVersionRequest
from ..model.list_application_app_version_response import ListApplicationAppVersionResponse
from ..model.patch_application_app_version_request import PatchApplicationAppVersionRequest
from ..model.patch_application_app_version_response import PatchApplicationAppVersionResponse


class ApplicationAppVersion(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def contacts_range_suggest(self, request: ContactsRangeSuggestApplicationAppVersionRequest, option: Optional[
        RequestOption] = None) -> ContactsRangeSuggestApplicationAppVersionResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ContactsRangeSuggestApplicationAppVersionResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                                     ContactsRangeSuggestApplicationAppVersionResponse)
        response.raw = resp

        return response

    async def acontacts_range_suggest(self, request: ContactsRangeSuggestApplicationAppVersionRequest, option: Optional[
        RequestOption] = None) -> ContactsRangeSuggestApplicationAppVersionResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ContactsRangeSuggestApplicationAppVersionResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                                     ContactsRangeSuggestApplicationAppVersionResponse)
        response.raw = resp

        return response

    def get(self, request: GetApplicationAppVersionRequest,
            option: Optional[RequestOption] = None) -> GetApplicationAppVersionResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetApplicationAppVersionResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                    GetApplicationAppVersionResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetApplicationAppVersionRequest,
                   option: Optional[RequestOption] = None) -> GetApplicationAppVersionResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetApplicationAppVersionResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                    GetApplicationAppVersionResponse)
        response.raw = resp

        return response

    def list(self, request: ListApplicationAppVersionRequest,
             option: Optional[RequestOption] = None) -> ListApplicationAppVersionResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListApplicationAppVersionResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     ListApplicationAppVersionResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListApplicationAppVersionRequest,
                    option: Optional[RequestOption] = None) -> ListApplicationAppVersionResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListApplicationAppVersionResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     ListApplicationAppVersionResponse)
        response.raw = resp

        return response

    def patch(self, request: PatchApplicationAppVersionRequest,
              option: Optional[RequestOption] = None) -> PatchApplicationAppVersionResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PatchApplicationAppVersionResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                      PatchApplicationAppVersionResponse)
        response.raw = resp

        return response

    async def apatch(self, request: PatchApplicationAppVersionRequest,
                     option: Optional[RequestOption] = None) -> PatchApplicationAppVersionResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PatchApplicationAppVersionResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                      PatchApplicationAppVersionResponse)
        response.raw = resp

        return response
