# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .add_sign_instance_request_body import AddSignInstanceRequestBody


class AddSignInstanceRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[AddSignInstanceRequestBody] = None

    @staticmethod
    def builder() -> "AddSignInstanceRequestBuilder":
        return AddSignInstanceRequestBuilder()


class AddSignInstanceRequestBuilder(object):

    def __init__(self) -> None:
        add_sign_instance_request = AddSignInstanceRequest()
        add_sign_instance_request.http_method = HttpMethod.POST
        add_sign_instance_request.uri = "/open-apis/approval/v4/instances/add_sign"
        add_sign_instance_request.token_types = {AccessTokenType.TENANT}
        self._add_sign_instance_request: AddSignInstanceRequest = add_sign_instance_request

    def request_body(self, request_body: AddSignInstanceRequestBody) -> "AddSignInstanceRequestBuilder":
        self._add_sign_instance_request.request_body = request_body
        self._add_sign_instance_request.body = request_body
        return self

    def build(self) -> AddSignInstanceRequest:
        return self._add_sign_instance_request
