# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .approval_config import ApprovalConfig
from .approval_create_viewers import ApprovalCreateViewers
from .approval_form import ApprovalForm
from .approval_node import ApprovalNode
from .approval_setting import ApprovalSetting
from .i18n_resource import I18nResource


class ApprovalCreate(object):
    _types = {
        "approval_name": str,
        "approval_code": str,
        "description": str,
        "viewers": List[ApprovalCreateViewers],
        "form": ApprovalForm,
        "node_list": List[ApprovalNode],
        "settings": ApprovalSetting,
        "config": ApprovalConfig,
        "icon": int,
        "i18n_resources": List[I18nResource],
        "process_manager_ids": List[str],
    }

    def __init__(self, d=None):
        self.approval_name: Optional[str] = None
        self.approval_code: Optional[str] = None
        self.description: Optional[str] = None
        self.viewers: Optional[List[ApprovalCreateViewers]] = None
        self.form: Optional[ApprovalForm] = None
        self.node_list: Optional[List[ApprovalNode]] = None
        self.settings: Optional[ApprovalSetting] = None
        self.config: Optional[ApprovalConfig] = None
        self.icon: Optional[int] = None
        self.i18n_resources: Optional[List[I18nResource]] = None
        self.process_manager_ids: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ApprovalCreateBuilder":
        return ApprovalCreateBuilder()


class ApprovalCreateBuilder(object):
    def __init__(self) -> None:
        self._approval_create = ApprovalCreate()

    def approval_name(self, approval_name: str) -> "ApprovalCreateBuilder":
        self._approval_create.approval_name = approval_name
        return self

    def approval_code(self, approval_code: str) -> "ApprovalCreateBuilder":
        self._approval_create.approval_code = approval_code
        return self

    def description(self, description: str) -> "ApprovalCreateBuilder":
        self._approval_create.description = description
        return self

    def viewers(self, viewers: List[ApprovalCreateViewers]) -> "ApprovalCreateBuilder":
        self._approval_create.viewers = viewers
        return self

    def form(self, form: ApprovalForm) -> "ApprovalCreateBuilder":
        self._approval_create.form = form
        return self

    def node_list(self, node_list: List[ApprovalNode]) -> "ApprovalCreateBuilder":
        self._approval_create.node_list = node_list
        return self

    def settings(self, settings: ApprovalSetting) -> "ApprovalCreateBuilder":
        self._approval_create.settings = settings
        return self

    def config(self, config: ApprovalConfig) -> "ApprovalCreateBuilder":
        self._approval_create.config = config
        return self

    def icon(self, icon: int) -> "ApprovalCreateBuilder":
        self._approval_create.icon = icon
        return self

    def i18n_resources(self, i18n_resources: List[I18nResource]) -> "ApprovalCreateBuilder":
        self._approval_create.i18n_resources = i18n_resources
        return self

    def process_manager_ids(self, process_manager_ids: List[str]) -> "ApprovalCreateBuilder":
        self._approval_create.process_manager_ids = process_manager_ids
        return self

    def build(self) -> "ApprovalCreate":
        return self._approval_create
