# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .task_approve import TaskApprove


class ApproveTaskRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[TaskApprove] = None

    @staticmethod
    def builder() -> "ApproveTaskRequestBuilder":
        return ApproveTaskRequestBuilder()


class ApproveTaskRequestBuilder(object):

    def __init__(self) -> None:
        approve_task_request = ApproveTaskRequest()
        approve_task_request.http_method = HttpMethod.POST
        approve_task_request.uri = "/open-apis/approval/v4/tasks/approve"
        approve_task_request.token_types = {AccessTokenType.TENANT}
        self._approve_task_request: ApproveTaskRequest = approve_task_request

    def user_id_type(self, user_id_type: str) -> "ApproveTaskRequestBuilder":
        self._approve_task_request.user_id_type = user_id_type
        self._approve_task_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: TaskApprove) -> "ApproveTaskRequestBuilder":
        self._approve_task_request.request_body = request_body
        self._approve_task_request.body = request_body
        return self

    def build(self) -> ApproveTaskRequest:
        return self._approve_task_request
