# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class CcSearch(object):
    _types = {
        "user_id": str,
        "approval_code": str,
        "instance_code": str,
        "instance_external_id": str,
        "group_external_id": str,
        "cc_title": str,
        "read_status": str,
        "cc_create_time_from": int,
        "cc_create_time_to": int,
        "locale": str,
    }

    def __init__(self, d=None):
        self.user_id: Optional[str] = None
        self.approval_code: Optional[str] = None
        self.instance_code: Optional[str] = None
        self.instance_external_id: Optional[str] = None
        self.group_external_id: Optional[str] = None
        self.cc_title: Optional[str] = None
        self.read_status: Optional[str] = None
        self.cc_create_time_from: Optional[int] = None
        self.cc_create_time_to: Optional[int] = None
        self.locale: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CcSearchBuilder":
        return CcSearchBuilder()


class CcSearchBuilder(object):
    def __init__(self) -> None:
        self._cc_search = CcSearch()

    def user_id(self, user_id: str) -> "CcSearchBuilder":
        self._cc_search.user_id = user_id
        return self

    def approval_code(self, approval_code: str) -> "CcSearchBuilder":
        self._cc_search.approval_code = approval_code
        return self

    def instance_code(self, instance_code: str) -> "CcSearchBuilder":
        self._cc_search.instance_code = instance_code
        return self

    def instance_external_id(self, instance_external_id: str) -> "CcSearchBuilder":
        self._cc_search.instance_external_id = instance_external_id
        return self

    def group_external_id(self, group_external_id: str) -> "CcSearchBuilder":
        self._cc_search.group_external_id = group_external_id
        return self

    def cc_title(self, cc_title: str) -> "CcSearchBuilder":
        self._cc_search.cc_title = cc_title
        return self

    def read_status(self, read_status: str) -> "CcSearchBuilder":
        self._cc_search.read_status = read_status
        return self

    def cc_create_time_from(self, cc_create_time_from: int) -> "CcSearchBuilder":
        self._cc_search.cc_create_time_from = cc_create_time_from
        return self

    def cc_create_time_to(self, cc_create_time_to: int) -> "CcSearchBuilder":
        self._cc_search.cc_create_time_to = cc_create_time_to
        return self

    def locale(self, locale: str) -> "CcSearchBuilder":
        self._cc_search.locale = locale
        return self

    def build(self) -> "CcSearch":
        return self._cc_search
