# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .cc_search_node import CcSearchNode
from .instance_search_approval import InstanceSearchApproval
from .instance_search_group import InstanceSearchGroup
from .instance_search_node import InstanceSearchNode


class CcSearchItem(object):
    _types = {
        "approval": InstanceSearchApproval,
        "group": InstanceSearchGroup,
        "instance": InstanceSearchNode,
        "cc": CcSearchNode,
    }

    def __init__(self, d=None):
        self.approval: Optional[InstanceSearchApproval] = None
        self.group: Optional[InstanceSearchGroup] = None
        self.instance: Optional[InstanceSearchNode] = None
        self.cc: Optional[CcSearchNode] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CcSearchItemBuilder":
        return CcSearchItemBuilder()


class CcSearchItemBuilder(object):
    def __init__(self) -> None:
        self._cc_search_item = CcSearchItem()

    def approval(self, approval: InstanceSearchApproval) -> "CcSearchItemBuilder":
        self._cc_search_item.approval = approval
        return self

    def group(self, group: InstanceSearchGroup) -> "CcSearchItemBuilder":
        self._cc_search_item.group = group
        return self

    def instance(self, instance: InstanceSearchNode) -> "CcSearchItemBuilder":
        self._cc_search_item.instance = instance
        return self

    def cc(self, cc: CcSearchNode) -> "CcSearchItemBuilder":
        self._cc_search_item.cc = cc
        return self

    def build(self) -> "CcSearchItem":
        return self._cc_search_item
