# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .comment_at_info import CommentAtInfo
from .comment_reply import CommentReply


class Comment(object):
    _types = {
        "id": int,
        "content": str,
        "create_time": int,
        "update_time": int,
        "is_delete": int,
        "replies": List[CommentReply],
        "at_info_list": List[CommentAtInfo],
        "commentator": str,
        "extra": str,
    }

    def __init__(self, d=None):
        self.id: Optional[int] = None
        self.content: Optional[str] = None
        self.create_time: Optional[int] = None
        self.update_time: Optional[int] = None
        self.is_delete: Optional[int] = None
        self.replies: Optional[List[CommentReply]] = None
        self.at_info_list: Optional[List[CommentAtInfo]] = None
        self.commentator: Optional[str] = None
        self.extra: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CommentBuilder":
        return CommentBuilder()


class CommentBuilder(object):
    def __init__(self) -> None:
        self._comment = Comment()

    def id(self, id: int) -> "CommentBuilder":
        self._comment.id = id
        return self

    def content(self, content: str) -> "CommentBuilder":
        self._comment.content = content
        return self

    def create_time(self, create_time: int) -> "CommentBuilder":
        self._comment.create_time = create_time
        return self

    def update_time(self, update_time: int) -> "CommentBuilder":
        self._comment.update_time = update_time
        return self

    def is_delete(self, is_delete: int) -> "CommentBuilder":
        self._comment.is_delete = is_delete
        return self

    def replies(self, replies: List[CommentReply]) -> "CommentBuilder":
        self._comment.replies = replies
        return self

    def at_info_list(self, at_info_list: List[CommentAtInfo]) -> "CommentBuilder":
        self._comment.at_info_list = at_info_list
        return self

    def commentator(self, commentator: str) -> "CommentBuilder":
        self._comment.commentator = commentator
        return self

    def extra(self, extra: str) -> "CommentBuilder":
        self._comment.extra = extra
        return self

    def build(self) -> "Comment":
        return self._comment
