# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .comment_at_info import CommentAtInfo


class CommentRequest(object):
    _types = {
        "content": str,
        "at_info_list": List[CommentAtInfo],
        "parent_comment_id": int,
        "comment_id": int,
        "disable_bot": bool,
        "extra": str,
    }

    def __init__(self, d=None):
        self.content: Optional[str] = None
        self.at_info_list: Optional[List[CommentAtInfo]] = None
        self.parent_comment_id: Optional[int] = None
        self.comment_id: Optional[int] = None
        self.disable_bot: Optional[bool] = None
        self.extra: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CommentRequestBuilder":
        return CommentRequestBuilder()


class CommentRequestBuilder(object):
    def __init__(self) -> None:
        self._comment_request = CommentRequest()

    def content(self, content: str) -> "CommentRequestBuilder":
        self._comment_request.content = content
        return self

    def at_info_list(self, at_info_list: List[CommentAtInfo]) -> "CommentRequestBuilder":
        self._comment_request.at_info_list = at_info_list
        return self

    def parent_comment_id(self, parent_comment_id: int) -> "CommentRequestBuilder":
        self._comment_request.parent_comment_id = parent_comment_id
        return self

    def comment_id(self, comment_id: int) -> "CommentRequestBuilder":
        self._comment_request.comment_id = comment_id
        return self

    def disable_bot(self, disable_bot: bool) -> "CommentRequestBuilder":
        self._comment_request.disable_bot = disable_bot
        return self

    def extra(self, extra: str) -> "CommentRequestBuilder":
        self._comment_request.extra = extra
        return self

    def build(self) -> "CommentRequest":
        return self._comment_request
