# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .instance_create import InstanceCreate


class CreateInstanceRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[InstanceCreate] = None

    @staticmethod
    def builder() -> "CreateInstanceRequestBuilder":
        return CreateInstanceRequestBuilder()


class CreateInstanceRequestBuilder(object):

    def __init__(self) -> None:
        create_instance_request = CreateInstanceRequest()
        create_instance_request.http_method = HttpMethod.POST
        create_instance_request.uri = "/open-apis/approval/v4/instances"
        create_instance_request.token_types = {AccessTokenType.TENANT}
        self._create_instance_request: CreateInstanceRequest = create_instance_request

    def request_body(self, request_body: InstanceCreate) -> "CreateInstanceRequestBuilder":
        self._create_instance_request.request_body = request_body
        self._create_instance_request.body = request_body
        return self

    def build(self) -> CreateInstanceRequest:
        return self._create_instance_request
