# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .external_instance_task import ExternalInstanceTask


class ExteranlInstanceCheck(object):
    _types = {
        "instance_id": str,
        "update_time": int,
        "tasks": List[ExternalInstanceTask],
    }

    def __init__(self, d=None):
        self.instance_id: Optional[str] = None
        self.update_time: Optional[int] = None
        self.tasks: Optional[List[ExternalInstanceTask]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ExteranlInstanceCheckBuilder":
        return ExteranlInstanceCheckBuilder()


class ExteranlInstanceCheckBuilder(object):
    def __init__(self) -> None:
        self._exteranl_instance_check = ExteranlInstanceCheck()

    def instance_id(self, instance_id: str) -> "ExteranlInstanceCheckBuilder":
        self._exteranl_instance_check.instance_id = instance_id
        return self

    def update_time(self, update_time: int) -> "ExteranlInstanceCheckBuilder":
        self._exteranl_instance_check.update_time = update_time
        return self

    def tasks(self, tasks: List[ExternalInstanceTask]) -> "ExteranlInstanceCheckBuilder":
        self._exteranl_instance_check.tasks = tasks
        return self

    def build(self) -> "ExteranlInstanceCheck":
        return self._exteranl_instance_check
