# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .external_task_item import ExternalTaskItem


class ExternalTaskList(object):
    _types = {
        "instance_id": str,
        "approval_id": str,
        "approval_code": str,
        "status": str,
        "update_time": int,
        "tasks": List[ExternalTaskItem],
    }

    def __init__(self, d=None):
        self.instance_id: Optional[str] = None
        self.approval_id: Optional[str] = None
        self.approval_code: Optional[str] = None
        self.status: Optional[str] = None
        self.update_time: Optional[int] = None
        self.tasks: Optional[List[ExternalTaskItem]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ExternalTaskListBuilder":
        return ExternalTaskListBuilder()


class ExternalTaskListBuilder(object):
    def __init__(self) -> None:
        self._external_task_list = ExternalTaskList()

    def instance_id(self, instance_id: str) -> "ExternalTaskListBuilder":
        self._external_task_list.instance_id = instance_id
        return self

    def approval_id(self, approval_id: str) -> "ExternalTaskListBuilder":
        self._external_task_list.approval_id = approval_id
        return self

    def approval_code(self, approval_code: str) -> "ExternalTaskListBuilder":
        self._external_task_list.approval_code = approval_code
        return self

    def status(self, status: str) -> "ExternalTaskListBuilder":
        self._external_task_list.status = status
        return self

    def update_time(self, update_time: int) -> "ExternalTaskListBuilder":
        self._external_task_list.update_time = update_time
        return self

    def tasks(self, tasks: List[ExternalTaskItem]) -> "ExternalTaskListBuilder":
        self._external_task_list.tasks = tasks
        return self

    def build(self) -> "ExternalTaskList":
        return self._external_task_list
