# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class FieldGroup(object):
    _types = {
        "writable": List[str],
        "readable": List[str],
    }

    def __init__(self, d=None):
        self.writable: Optional[List[str]] = None
        self.readable: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "FieldGroupBuilder":
        return FieldGroupBuilder()


class FieldGroupBuilder(object):
    def __init__(self) -> None:
        self._field_group = FieldGroup()

    def writable(self, writable: List[str]) -> "FieldGroupBuilder":
        self._field_group.writable = writable
        return self

    def readable(self, readable: List[str]) -> "FieldGroupBuilder":
        self._field_group.readable = readable
        return self

    def build(self) -> "FieldGroup":
        return self._field_group
