# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class File(object):
    _types = {
        "url": str,
        "file_size": int,
        "title": str,
        "type": str,
    }

    def __init__(self, d=None):
        self.url: Optional[str] = None
        self.file_size: Optional[int] = None
        self.title: Optional[str] = None
        self.type: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "FileBuilder":
        return FileBuilder()


class FileBuilder(object):
    def __init__(self) -> None:
        self._file = File()

    def url(self, url: str) -> "FileBuilder":
        self._file.url = url
        return self

    def file_size(self, file_size: int) -> "FileBuilder":
        self._file.file_size = file_size
        return self

    def title(self, title: str) -> "FileBuilder":
        self._file.title = title
        return self

    def type(self, type: str) -> "FileBuilder":
        self._file.type = type
        return self

    def build(self) -> "File":
        return self._file
