# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .instance_comment import InstanceComment
from .instance_task import InstanceTask
from .instance_timeline import InstanceTimeline


class GetInstanceResponseBody(object):
    _types = {
        "approval_name": str,
        "start_time": int,
        "end_time": int,
        "user_id": str,
        "open_id": str,
        "serial_number": str,
        "department_id": str,
        "status": str,
        "uuid": str,
        "form": str,
        "task_list": List[InstanceTask],
        "comment_list": List[InstanceComment],
        "timeline": List[InstanceTimeline],
        "modified_instance_code": str,
        "reverted_instance_code": str,
        "approval_code": str,
        "reverted": bool,
        "instance_code": str,
    }

    def __init__(self, d=None):
        self.approval_name: Optional[str] = None
        self.start_time: Optional[int] = None
        self.end_time: Optional[int] = None
        self.user_id: Optional[str] = None
        self.open_id: Optional[str] = None
        self.serial_number: Optional[str] = None
        self.department_id: Optional[str] = None
        self.status: Optional[str] = None
        self.uuid: Optional[str] = None
        self.form: Optional[str] = None
        self.task_list: Optional[List[InstanceTask]] = None
        self.comment_list: Optional[List[InstanceComment]] = None
        self.timeline: Optional[List[InstanceTimeline]] = None
        self.modified_instance_code: Optional[str] = None
        self.reverted_instance_code: Optional[str] = None
        self.approval_code: Optional[str] = None
        self.reverted: Optional[bool] = None
        self.instance_code: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "GetInstanceResponseBodyBuilder":
        return GetInstanceResponseBodyBuilder()


class GetInstanceResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._get_instance_response_body = GetInstanceResponseBody()

    def approval_name(self, approval_name: str) -> "GetInstanceResponseBodyBuilder":
        self._get_instance_response_body.approval_name = approval_name
        return self

    def start_time(self, start_time: int) -> "GetInstanceResponseBodyBuilder":
        self._get_instance_response_body.start_time = start_time
        return self

    def end_time(self, end_time: int) -> "GetInstanceResponseBodyBuilder":
        self._get_instance_response_body.end_time = end_time
        return self

    def user_id(self, user_id: str) -> "GetInstanceResponseBodyBuilder":
        self._get_instance_response_body.user_id = user_id
        return self

    def open_id(self, open_id: str) -> "GetInstanceResponseBodyBuilder":
        self._get_instance_response_body.open_id = open_id
        return self

    def serial_number(self, serial_number: str) -> "GetInstanceResponseBodyBuilder":
        self._get_instance_response_body.serial_number = serial_number
        return self

    def department_id(self, department_id: str) -> "GetInstanceResponseBodyBuilder":
        self._get_instance_response_body.department_id = department_id
        return self

    def status(self, status: str) -> "GetInstanceResponseBodyBuilder":
        self._get_instance_response_body.status = status
        return self

    def uuid(self, uuid: str) -> "GetInstanceResponseBodyBuilder":
        self._get_instance_response_body.uuid = uuid
        return self

    def form(self, form: str) -> "GetInstanceResponseBodyBuilder":
        self._get_instance_response_body.form = form
        return self

    def task_list(self, task_list: List[InstanceTask]) -> "GetInstanceResponseBodyBuilder":
        self._get_instance_response_body.task_list = task_list
        return self

    def comment_list(self, comment_list: List[InstanceComment]) -> "GetInstanceResponseBodyBuilder":
        self._get_instance_response_body.comment_list = comment_list
        return self

    def timeline(self, timeline: List[InstanceTimeline]) -> "GetInstanceResponseBodyBuilder":
        self._get_instance_response_body.timeline = timeline
        return self

    def modified_instance_code(self, modified_instance_code: str) -> "GetInstanceResponseBodyBuilder":
        self._get_instance_response_body.modified_instance_code = modified_instance_code
        return self

    def reverted_instance_code(self, reverted_instance_code: str) -> "GetInstanceResponseBodyBuilder":
        self._get_instance_response_body.reverted_instance_code = reverted_instance_code
        return self

    def approval_code(self, approval_code: str) -> "GetInstanceResponseBodyBuilder":
        self._get_instance_response_body.approval_code = approval_code
        return self

    def reverted(self, reverted: bool) -> "GetInstanceResponseBodyBuilder":
        self._get_instance_response_body.reverted = reverted
        return self

    def instance_code(self, instance_code: str) -> "GetInstanceResponseBodyBuilder":
        self._get_instance_response_body.instance_code = instance_code
        return self

    def build(self) -> "GetInstanceResponseBody":
        return self._get_instance_response_body
