# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Instance(object):
    _types = {
        "instance_code": str,
        "approval_name": str,
        "start_time": int,
        "end_time": int,
        "user_id": str,
        "serial_id": str,
    }

    def __init__(self, d=None):
        self.instance_code: Optional[str] = None
        self.approval_name: Optional[str] = None
        self.start_time: Optional[int] = None
        self.end_time: Optional[int] = None
        self.user_id: Optional[str] = None
        self.serial_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "InstanceBuilder":
        return InstanceBuilder()


class InstanceBuilder(object):
    def __init__(self) -> None:
        self._instance = Instance()

    def instance_code(self, instance_code: str) -> "InstanceBuilder":
        self._instance.instance_code = instance_code
        return self

    def approval_name(self, approval_name: str) -> "InstanceBuilder":
        self._instance.approval_name = approval_name
        return self

    def start_time(self, start_time: int) -> "InstanceBuilder":
        self._instance.start_time = start_time
        return self

    def end_time(self, end_time: int) -> "InstanceBuilder":
        self._instance.end_time = end_time
        return self

    def user_id(self, user_id: str) -> "InstanceBuilder":
        self._instance.user_id = user_id
        return self

    def serial_id(self, serial_id: str) -> "InstanceBuilder":
        self._instance.serial_id = serial_id
        return self

    def build(self) -> "Instance":
        return self._instance
