# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class InstanceCancel(object):
    _types = {
        "approval_code": str,
        "instance_code": str,
        "user_id": str,
    }

    def __init__(self, d=None):
        self.approval_code: Optional[str] = None
        self.instance_code: Optional[str] = None
        self.user_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "InstanceCancelBuilder":
        return InstanceCancelBuilder()


class InstanceCancelBuilder(object):
    def __init__(self) -> None:
        self._instance_cancel = InstanceCancel()

    def approval_code(self, approval_code: str) -> "InstanceCancelBuilder":
        self._instance_cancel.approval_code = approval_code
        return self

    def instance_code(self, instance_code: str) -> "InstanceCancelBuilder":
        self._instance_cancel.instance_code = instance_code
        return self

    def user_id(self, user_id: str) -> "InstanceCancelBuilder":
        self._instance_cancel.user_id = user_id
        return self

    def build(self) -> "InstanceCancel":
        return self._instance_cancel
