# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .i18n_resource import I18nResource
from .node_approver import NodeApprover
from .node_cc import NodeCc


class InstanceCreate(object):
    _types = {
        "approval_code": str,
        "user_id": str,
        "open_id": str,
        "department_id": str,
        "form": str,
        "node_approver_user_id_list": List[NodeApprover],
        "node_approver_open_id_list": List[NodeApprover],
        "node_cc_user_id_list": List[NodeCc],
        "node_cc_open_id_list": List[NodeCc],
        "uuid": str,
        "allow_resubmit": bool,
        "allow_submit_again": bool,
        "cancel_bot_notification": int,
        "forbid_revoke": bool,
        "i18n_resources": List[I18nResource],
        "title": str,
        "title_display_method": int,
    }

    def __init__(self, d=None):
        self.approval_code: Optional[str] = None
        self.user_id: Optional[str] = None
        self.open_id: Optional[str] = None
        self.department_id: Optional[str] = None
        self.form: Optional[str] = None
        self.node_approver_user_id_list: Optional[List[NodeApprover]] = None
        self.node_approver_open_id_list: Optional[List[NodeApprover]] = None
        self.node_cc_user_id_list: Optional[List[NodeCc]] = None
        self.node_cc_open_id_list: Optional[List[NodeCc]] = None
        self.uuid: Optional[str] = None
        self.allow_resubmit: Optional[bool] = None
        self.allow_submit_again: Optional[bool] = None
        self.cancel_bot_notification: Optional[int] = None
        self.forbid_revoke: Optional[bool] = None
        self.i18n_resources: Optional[List[I18nResource]] = None
        self.title: Optional[str] = None
        self.title_display_method: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "InstanceCreateBuilder":
        return InstanceCreateBuilder()


class InstanceCreateBuilder(object):
    def __init__(self) -> None:
        self._instance_create = InstanceCreate()

    def approval_code(self, approval_code: str) -> "InstanceCreateBuilder":
        self._instance_create.approval_code = approval_code
        return self

    def user_id(self, user_id: str) -> "InstanceCreateBuilder":
        self._instance_create.user_id = user_id
        return self

    def open_id(self, open_id: str) -> "InstanceCreateBuilder":
        self._instance_create.open_id = open_id
        return self

    def department_id(self, department_id: str) -> "InstanceCreateBuilder":
        self._instance_create.department_id = department_id
        return self

    def form(self, form: str) -> "InstanceCreateBuilder":
        self._instance_create.form = form
        return self

    def node_approver_user_id_list(self, node_approver_user_id_list: List[NodeApprover]) -> "InstanceCreateBuilder":
        self._instance_create.node_approver_user_id_list = node_approver_user_id_list
        return self

    def node_approver_open_id_list(self, node_approver_open_id_list: List[NodeApprover]) -> "InstanceCreateBuilder":
        self._instance_create.node_approver_open_id_list = node_approver_open_id_list
        return self

    def node_cc_user_id_list(self, node_cc_user_id_list: List[NodeCc]) -> "InstanceCreateBuilder":
        self._instance_create.node_cc_user_id_list = node_cc_user_id_list
        return self

    def node_cc_open_id_list(self, node_cc_open_id_list: List[NodeCc]) -> "InstanceCreateBuilder":
        self._instance_create.node_cc_open_id_list = node_cc_open_id_list
        return self

    def uuid(self, uuid: str) -> "InstanceCreateBuilder":
        self._instance_create.uuid = uuid
        return self

    def allow_resubmit(self, allow_resubmit: bool) -> "InstanceCreateBuilder":
        self._instance_create.allow_resubmit = allow_resubmit
        return self

    def allow_submit_again(self, allow_submit_again: bool) -> "InstanceCreateBuilder":
        self._instance_create.allow_submit_again = allow_submit_again
        return self

    def cancel_bot_notification(self, cancel_bot_notification: int) -> "InstanceCreateBuilder":
        self._instance_create.cancel_bot_notification = cancel_bot_notification
        return self

    def forbid_revoke(self, forbid_revoke: bool) -> "InstanceCreateBuilder":
        self._instance_create.forbid_revoke = forbid_revoke
        return self

    def i18n_resources(self, i18n_resources: List[I18nResource]) -> "InstanceCreateBuilder":
        self._instance_create.i18n_resources = i18n_resources
        return self

    def title(self, title: str) -> "InstanceCreateBuilder":
        self._instance_create.title = title
        return self

    def title_display_method(self, title_display_method: int) -> "InstanceCreateBuilder":
        self._instance_create.title_display_method = title_display_method
        return self

    def build(self) -> "InstanceCreate":
        return self._instance_create
