# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .instance_search_approval_external import InstanceSearchApprovalExternal


class InstanceSearchApproval(object):
    _types = {
        "code": str,
        "name": str,
        "is_external": bool,
        "external": InstanceSearchApprovalExternal,
        "approval_id": int,
        "icon": str,
    }

    def __init__(self, d=None):
        self.code: Optional[str] = None
        self.name: Optional[str] = None
        self.is_external: Optional[bool] = None
        self.external: Optional[InstanceSearchApprovalExternal] = None
        self.approval_id: Optional[int] = None
        self.icon: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "InstanceSearchApprovalBuilder":
        return InstanceSearchApprovalBuilder()


class InstanceSearchApprovalBuilder(object):
    def __init__(self) -> None:
        self._instance_search_approval = InstanceSearchApproval()

    def code(self, code: str) -> "InstanceSearchApprovalBuilder":
        self._instance_search_approval.code = code
        return self

    def name(self, name: str) -> "InstanceSearchApprovalBuilder":
        self._instance_search_approval.name = name
        return self

    def is_external(self, is_external: bool) -> "InstanceSearchApprovalBuilder":
        self._instance_search_approval.is_external = is_external
        return self

    def external(self, external: InstanceSearchApprovalExternal) -> "InstanceSearchApprovalBuilder":
        self._instance_search_approval.external = external
        return self

    def approval_id(self, approval_id: int) -> "InstanceSearchApprovalBuilder":
        self._instance_search_approval.approval_id = approval_id
        return self

    def icon(self, icon: str) -> "InstanceSearchApprovalBuilder":
        self._instance_search_approval.icon = icon
        return self

    def build(self) -> "InstanceSearchApproval":
        return self._instance_search_approval
