# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .instance_search_approval import InstanceSearchApproval
from .instance_search_group import InstanceSearchGroup
from .instance_search_node import InstanceSearchNode


class InstanceSearchItem(object):
    _types = {
        "approval": InstanceSearchApproval,
        "group": InstanceSearchGroup,
        "instance": InstanceSearchNode,
    }

    def __init__(self, d=None):
        self.approval: Optional[InstanceSearchApproval] = None
        self.group: Optional[InstanceSearchGroup] = None
        self.instance: Optional[InstanceSearchNode] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "InstanceSearchItemBuilder":
        return InstanceSearchItemBuilder()


class InstanceSearchItemBuilder(object):
    def __init__(self) -> None:
        self._instance_search_item = InstanceSearchItem()

    def approval(self, approval: InstanceSearchApproval) -> "InstanceSearchItemBuilder":
        self._instance_search_item.approval = approval
        return self

    def group(self, group: InstanceSearchGroup) -> "InstanceSearchItemBuilder":
        self._instance_search_item.group = group
        return self

    def instance(self, instance: InstanceSearchNode) -> "InstanceSearchItemBuilder":
        self._instance_search_item.instance = instance
        return self

    def build(self) -> "InstanceSearchItem":
        return self._instance_search_item
