# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .instance_search_link import InstanceSearchLink


class InstanceSearchNode(object):
    _types = {
        "code": str,
        "external_id": str,
        "user_id": str,
        "start_time": int,
        "end_time": int,
        "status": str,
        "title": str,
        "extra": str,
        "serial_id": str,
        "link": InstanceSearchLink,
    }

    def __init__(self, d=None):
        self.code: Optional[str] = None
        self.external_id: Optional[str] = None
        self.user_id: Optional[str] = None
        self.start_time: Optional[int] = None
        self.end_time: Optional[int] = None
        self.status: Optional[str] = None
        self.title: Optional[str] = None
        self.extra: Optional[str] = None
        self.serial_id: Optional[str] = None
        self.link: Optional[InstanceSearchLink] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "InstanceSearchNodeBuilder":
        return InstanceSearchNodeBuilder()


class InstanceSearchNodeBuilder(object):
    def __init__(self) -> None:
        self._instance_search_node = InstanceSearchNode()

    def code(self, code: str) -> "InstanceSearchNodeBuilder":
        self._instance_search_node.code = code
        return self

    def external_id(self, external_id: str) -> "InstanceSearchNodeBuilder":
        self._instance_search_node.external_id = external_id
        return self

    def user_id(self, user_id: str) -> "InstanceSearchNodeBuilder":
        self._instance_search_node.user_id = user_id
        return self

    def start_time(self, start_time: int) -> "InstanceSearchNodeBuilder":
        self._instance_search_node.start_time = start_time
        return self

    def end_time(self, end_time: int) -> "InstanceSearchNodeBuilder":
        self._instance_search_node.end_time = end_time
        return self

    def status(self, status: str) -> "InstanceSearchNodeBuilder":
        self._instance_search_node.status = status
        return self

    def title(self, title: str) -> "InstanceSearchNodeBuilder":
        self._instance_search_node.title = title
        return self

    def extra(self, extra: str) -> "InstanceSearchNodeBuilder":
        self._instance_search_node.extra = extra
        return self

    def serial_id(self, serial_id: str) -> "InstanceSearchNodeBuilder":
        self._instance_search_node.serial_id = serial_id
        return self

    def link(self, link: InstanceSearchLink) -> "InstanceSearchNodeBuilder":
        self._instance_search_node.link = link
        return self

    def build(self) -> "InstanceSearchNode":
        return self._instance_search_node
