# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class InstanceTask(object):
    _types = {
        "id": str,
        "user_id": str,
        "open_id": str,
        "status": str,
        "node_id": str,
        "node_name": str,
        "custom_node_id": str,
        "type": str,
        "start_time": int,
        "end_time": int,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.user_id: Optional[str] = None
        self.open_id: Optional[str] = None
        self.status: Optional[str] = None
        self.node_id: Optional[str] = None
        self.node_name: Optional[str] = None
        self.custom_node_id: Optional[str] = None
        self.type: Optional[str] = None
        self.start_time: Optional[int] = None
        self.end_time: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "InstanceTaskBuilder":
        return InstanceTaskBuilder()


class InstanceTaskBuilder(object):
    def __init__(self) -> None:
        self._instance_task = InstanceTask()

    def id(self, id: str) -> "InstanceTaskBuilder":
        self._instance_task.id = id
        return self

    def user_id(self, user_id: str) -> "InstanceTaskBuilder":
        self._instance_task.user_id = user_id
        return self

    def open_id(self, open_id: str) -> "InstanceTaskBuilder":
        self._instance_task.open_id = open_id
        return self

    def status(self, status: str) -> "InstanceTaskBuilder":
        self._instance_task.status = status
        return self

    def node_id(self, node_id: str) -> "InstanceTaskBuilder":
        self._instance_task.node_id = node_id
        return self

    def node_name(self, node_name: str) -> "InstanceTaskBuilder":
        self._instance_task.node_name = node_name
        return self

    def custom_node_id(self, custom_node_id: str) -> "InstanceTaskBuilder":
        self._instance_task.custom_node_id = custom_node_id
        return self

    def type(self, type: str) -> "InstanceTaskBuilder":
        self._instance_task.type = type
        return self

    def start_time(self, start_time: int) -> "InstanceTaskBuilder":
        self._instance_task.start_time = start_time
        return self

    def end_time(self, end_time: int) -> "InstanceTaskBuilder":
        self._instance_task.end_time = end_time
        return self

    def build(self) -> "InstanceTask":
        return self._instance_task
