# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .external_task_list import ExternalTaskList


class ListExternalTaskResponseBody(object):
    _types = {
        "data": List[ExternalTaskList],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.data: Optional[List[ExternalTaskList]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListExternalTaskResponseBodyBuilder":
        return ListExternalTaskResponseBodyBuilder()


class ListExternalTaskResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_external_task_response_body = ListExternalTaskResponseBody()

    def data(self, data: List[ExternalTaskList]) -> "ListExternalTaskResponseBodyBuilder":
        self._list_external_task_response_body.data = data
        return self

    def page_token(self, page_token: str) -> "ListExternalTaskResponseBodyBuilder":
        self._list_external_task_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "ListExternalTaskResponseBodyBuilder":
        self._list_external_task_response_body.has_more = has_more
        return self

    def build(self) -> "ListExternalTaskResponseBody":
        return self._list_external_task_response_body
