# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListInstanceRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None
        self.approval_code: Optional[str] = None
        self.start_time: Optional[int] = None
        self.end_time: Optional[int] = None

    @staticmethod
    def builder() -> "ListInstanceRequestBuilder":
        return ListInstanceRequestBuilder()


class ListInstanceRequestBuilder(object):

    def __init__(self) -> None:
        list_instance_request = ListInstanceRequest()
        list_instance_request.http_method = HttpMethod.GET
        list_instance_request.uri = "/open-apis/approval/v4/instances"
        list_instance_request.token_types = {AccessTokenType.TENANT}
        self._list_instance_request: ListInstanceRequest = list_instance_request

    def page_size(self, page_size: int) -> "ListInstanceRequestBuilder":
        self._list_instance_request.page_size = page_size
        self._list_instance_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "ListInstanceRequestBuilder":
        self._list_instance_request.page_token = page_token
        self._list_instance_request.add_query("page_token", page_token)
        return self

    def approval_code(self, approval_code: str) -> "ListInstanceRequestBuilder":
        self._list_instance_request.approval_code = approval_code
        self._list_instance_request.add_query("approval_code", approval_code)
        return self

    def start_time(self, start_time: int) -> "ListInstanceRequestBuilder":
        self._list_instance_request.start_time = start_time
        self._list_instance_request.add_query("start_time", start_time)
        return self

    def end_time(self, end_time: int) -> "ListInstanceRequestBuilder":
        self._list_instance_request.end_time = end_time
        self._list_instance_request.add_query("end_time", end_time)
        return self

    def build(self) -> ListInstanceRequest:
        return self._list_instance_request
