# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class ManageableInstanceNode(object):
    _types = {
        "code": str,
        "start_user_id": str,
        "current_user_ids": List[str],
        "department_id": str,
        "node_name": str,
        "form": str,
        "version": str,
        "start_time": int,
        "end_time": int,
        "status": str,
        "serial_id": str,
        "status_display": str,
    }

    def __init__(self, d=None):
        self.code: Optional[str] = None
        self.start_user_id: Optional[str] = None
        self.current_user_ids: Optional[List[str]] = None
        self.department_id: Optional[str] = None
        self.node_name: Optional[str] = None
        self.form: Optional[str] = None
        self.version: Optional[str] = None
        self.start_time: Optional[int] = None
        self.end_time: Optional[int] = None
        self.status: Optional[str] = None
        self.serial_id: Optional[str] = None
        self.status_display: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ManageableInstanceNodeBuilder":
        return ManageableInstanceNodeBuilder()


class ManageableInstanceNodeBuilder(object):
    def __init__(self) -> None:
        self._manageable_instance_node = ManageableInstanceNode()

    def code(self, code: str) -> "ManageableInstanceNodeBuilder":
        self._manageable_instance_node.code = code
        return self

    def start_user_id(self, start_user_id: str) -> "ManageableInstanceNodeBuilder":
        self._manageable_instance_node.start_user_id = start_user_id
        return self

    def current_user_ids(self, current_user_ids: List[str]) -> "ManageableInstanceNodeBuilder":
        self._manageable_instance_node.current_user_ids = current_user_ids
        return self

    def department_id(self, department_id: str) -> "ManageableInstanceNodeBuilder":
        self._manageable_instance_node.department_id = department_id
        return self

    def node_name(self, node_name: str) -> "ManageableInstanceNodeBuilder":
        self._manageable_instance_node.node_name = node_name
        return self

    def form(self, form: str) -> "ManageableInstanceNodeBuilder":
        self._manageable_instance_node.form = form
        return self

    def version(self, version: str) -> "ManageableInstanceNodeBuilder":
        self._manageable_instance_node.version = version
        return self

    def start_time(self, start_time: int) -> "ManageableInstanceNodeBuilder":
        self._manageable_instance_node.start_time = start_time
        return self

    def end_time(self, end_time: int) -> "ManageableInstanceNodeBuilder":
        self._manageable_instance_node.end_time = end_time
        return self

    def status(self, status: str) -> "ManageableInstanceNodeBuilder":
        self._manageable_instance_node.status = status
        return self

    def serial_id(self, serial_id: str) -> "ManageableInstanceNodeBuilder":
        self._manageable_instance_node.serial_id = serial_id
        return self

    def status_display(self, status_display: str) -> "ManageableInstanceNodeBuilder":
        self._manageable_instance_node.status_display = status_display
        return self

    def build(self) -> "ManageableInstanceNode":
        return self._manageable_instance_node
