# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .my_ai_comment import MyAiComment
from .my_ai_task import MyAiTask


class MyAiInstance(object):
    _types = {
        "name": str,
        "form": str,
        "tasks": List[MyAiTask],
        "comments": List[MyAiComment],
    }

    def __init__(self, d=None):
        self.name: Optional[str] = None
        self.form: Optional[str] = None
        self.tasks: Optional[List[MyAiTask]] = None
        self.comments: Optional[List[MyAiComment]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MyAiInstanceBuilder":
        return MyAiInstanceBuilder()


class MyAiInstanceBuilder(object):
    def __init__(self) -> None:
        self._my_ai_instance = MyAiInstance()

    def name(self, name: str) -> "MyAiInstanceBuilder":
        self._my_ai_instance.name = name
        return self

    def form(self, form: str) -> "MyAiInstanceBuilder":
        self._my_ai_instance.form = form
        return self

    def tasks(self, tasks: List[MyAiTask]) -> "MyAiInstanceBuilder":
        self._my_ai_instance.tasks = tasks
        return self

    def comments(self, comments: List[MyAiComment]) -> "MyAiInstanceBuilder":
        self._my_ai_instance.comments = comments
        return self

    def build(self) -> "MyAiInstance":
        return self._my_ai_instance
