# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .my_ai_present_card_variables import MyAiPresentCardVariables


class MyAiPresent(object):
    _types = {
        "type": str,
        "body": str,
        "callback_url": str,
        "callback_info": str,
        "card_template_id": str,
        "card_variables": MyAiPresentCardVariables,
    }

    def __init__(self, d=None):
        self.type: Optional[str] = None
        self.body: Optional[str] = None
        self.callback_url: Optional[str] = None
        self.callback_info: Optional[str] = None
        self.card_template_id: Optional[str] = None
        self.card_variables: Optional[MyAiPresentCardVariables] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MyAiPresentBuilder":
        return MyAiPresentBuilder()


class MyAiPresentBuilder(object):
    def __init__(self) -> None:
        self._my_ai_present = MyAiPresent()

    def type(self, type: str) -> "MyAiPresentBuilder":
        self._my_ai_present.type = type
        return self

    def body(self, body: str) -> "MyAiPresentBuilder":
        self._my_ai_present.body = body
        return self

    def callback_url(self, callback_url: str) -> "MyAiPresentBuilder":
        self._my_ai_present.callback_url = callback_url
        return self

    def callback_info(self, callback_info: str) -> "MyAiPresentBuilder":
        self._my_ai_present.callback_info = callback_info
        return self

    def card_template_id(self, card_template_id: str) -> "MyAiPresentBuilder":
        self._my_ai_present.card_template_id = card_template_id
        return self

    def card_variables(self, card_variables: MyAiPresentCardVariables) -> "MyAiPresentBuilder":
        self._my_ai_present.card_variables = card_variables
        return self

    def build(self) -> "MyAiPresent":
        return self._my_ai_present
