# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ObjectContext(object):
    _types = {
        "type": str,
        "biz_id": str,
    }

    def __init__(self, d=None):
        self.type: Optional[str] = None
        self.biz_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ObjectContextBuilder":
        return ObjectContextBuilder()


class ObjectContextBuilder(object):
    def __init__(self) -> None:
        self._object_context = ObjectContext()

    def type(self, type: str) -> "ObjectContextBuilder":
        self._object_context.type = type
        return self

    def biz_id(self, biz_id: str) -> "ObjectContextBuilder":
        self._object_context.biz_id = biz_id
        return self

    def build(self) -> "ObjectContext":
        return self._object_context
