# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class RemoveInstanceCommentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.user_id: Optional[int] = None
        self.instance_id: Optional[str] = None

    @staticmethod
    def builder() -> "RemoveInstanceCommentRequestBuilder":
        return RemoveInstanceCommentRequestBuilder()


class RemoveInstanceCommentRequestBuilder(object):

    def __init__(self) -> None:
        remove_instance_comment_request = RemoveInstanceCommentRequest()
        remove_instance_comment_request.http_method = HttpMethod.POST
        remove_instance_comment_request.uri = "/open-apis/approval/v4/instances/:instance_id/comments/remove"
        remove_instance_comment_request.token_types = {AccessTokenType.TENANT}
        self._remove_instance_comment_request: RemoveInstanceCommentRequest = remove_instance_comment_request

    def user_id_type(self, user_id_type: str) -> "RemoveInstanceCommentRequestBuilder":
        self._remove_instance_comment_request.user_id_type = user_id_type
        self._remove_instance_comment_request.add_query("user_id_type", user_id_type)
        return self

    def user_id(self, user_id: int) -> "RemoveInstanceCommentRequestBuilder":
        self._remove_instance_comment_request.user_id = user_id
        self._remove_instance_comment_request.add_query("user_id", user_id)
        return self

    def instance_id(self, instance_id: str) -> "RemoveInstanceCommentRequestBuilder":
        self._remove_instance_comment_request.instance_id = instance_id
        self._remove_instance_comment_request.paths["instance_id"] = str(instance_id)
        return self

    def build(self) -> RemoveInstanceCommentRequest:
        return self._remove_instance_comment_request
