# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class RollbackNode(object):
    _types = {
        "node_id": str,
        "node_name": str,
        "custom_node_id": str,
        "node_key": str,
    }

    def __init__(self, d=None):
        self.node_id: Optional[str] = None
        self.node_name: Optional[str] = None
        self.custom_node_id: Optional[str] = None
        self.node_key: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "RollbackNodeBuilder":
        return RollbackNodeBuilder()


class RollbackNodeBuilder(object):
    def __init__(self) -> None:
        self._rollback_node = RollbackNode()

    def node_id(self, node_id: str) -> "RollbackNodeBuilder":
        self._rollback_node.node_id = node_id
        return self

    def node_name(self, node_name: str) -> "RollbackNodeBuilder":
        self._rollback_node.node_name = node_name
        return self

    def custom_node_id(self, custom_node_id: str) -> "RollbackNodeBuilder":
        self._rollback_node.custom_node_id = custom_node_id
        return self

    def node_key(self, node_key: str) -> "RollbackNodeBuilder":
        self._rollback_node.node_key = node_key
        return self

    def build(self) -> "RollbackNode":
        return self._rollback_node
