# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .cc_search import CcSearch


class SearchCcInstanceRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[CcSearch] = None

    @staticmethod
    def builder() -> "SearchCcInstanceRequestBuilder":
        return SearchCcInstanceRequestBuilder()


class SearchCcInstanceRequestBuilder(object):

    def __init__(self) -> None:
        search_cc_instance_request = SearchCcInstanceRequest()
        search_cc_instance_request.http_method = HttpMethod.POST
        search_cc_instance_request.uri = "/open-apis/approval/v4/instances/search_cc"
        search_cc_instance_request.token_types = {AccessTokenType.TENANT}
        self._search_cc_instance_request: SearchCcInstanceRequest = search_cc_instance_request

    def page_size(self, page_size: int) -> "SearchCcInstanceRequestBuilder":
        self._search_cc_instance_request.page_size = page_size
        self._search_cc_instance_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "SearchCcInstanceRequestBuilder":
        self._search_cc_instance_request.page_token = page_token
        self._search_cc_instance_request.add_query("page_token", page_token)
        return self

    def user_id_type(self, user_id_type: str) -> "SearchCcInstanceRequestBuilder":
        self._search_cc_instance_request.user_id_type = user_id_type
        self._search_cc_instance_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: CcSearch) -> "SearchCcInstanceRequestBuilder":
        self._search_cc_instance_request.request_body = request_body
        self._search_cc_instance_request.body = request_body
        return self

    def build(self) -> SearchCcInstanceRequest:
        return self._search_cc_instance_request
