# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .cc_search_item import CcSearchItem


class SearchCcInstanceResponseBody(object):
    _types = {
        "count": int,
        "cc_list": List[CcSearchItem],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.count: Optional[int] = None
        self.cc_list: Optional[List[CcSearchItem]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SearchCcInstanceResponseBodyBuilder":
        return SearchCcInstanceResponseBodyBuilder()


class SearchCcInstanceResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._search_cc_instance_response_body = SearchCcInstanceResponseBody()

    def count(self, count: int) -> "SearchCcInstanceResponseBodyBuilder":
        self._search_cc_instance_response_body.count = count
        return self

    def cc_list(self, cc_list: List[CcSearchItem]) -> "SearchCcInstanceResponseBodyBuilder":
        self._search_cc_instance_response_body.cc_list = cc_list
        return self

    def page_token(self, page_token: str) -> "SearchCcInstanceResponseBodyBuilder":
        self._search_cc_instance_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "SearchCcInstanceResponseBodyBuilder":
        self._search_cc_instance_response_body.has_more = has_more
        return self

    def build(self) -> "SearchCcInstanceResponseBody":
        return self._search_cc_instance_response_body
