# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .task_search_item import TaskSearchItem


class SearchTaskResponseBody(object):
    _types = {
        "count": int,
        "task_list": List[TaskSearchItem],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.count: Optional[int] = None
        self.task_list: Optional[List[TaskSearchItem]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SearchTaskResponseBodyBuilder":
        return SearchTaskResponseBodyBuilder()


class SearchTaskResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._search_task_response_body = SearchTaskResponseBody()

    def count(self, count: int) -> "SearchTaskResponseBodyBuilder":
        self._search_task_response_body.count = count
        return self

    def task_list(self, task_list: List[TaskSearchItem]) -> "SearchTaskResponseBodyBuilder":
        self._search_task_response_body.task_list = task_list
        return self

    def page_token(self, page_token: str) -> "SearchTaskResponseBodyBuilder":
        self._search_task_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "SearchTaskResponseBodyBuilder":
        self._search_task_response_body.has_more = has_more
        return self

    def build(self) -> "SearchTaskResponseBody":
        return self._search_task_response_body
