# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .swap_shift_detail import SwapShiftDetail


class ShiftGroup(object):
    _types = {
        "type": str,
        "instance_code": str,
        "user_id": str,
        "swap_shift_user_id": str,
        "start_time": int,
        "end_time": int,
        "shift_reason": str,
        "swap_shift_details": List[SwapShiftDetail],
    }

    def __init__(self, d=None):
        self.type: Optional[str] = None
        self.instance_code: Optional[str] = None
        self.user_id: Optional[str] = None
        self.swap_shift_user_id: Optional[str] = None
        self.start_time: Optional[int] = None
        self.end_time: Optional[int] = None
        self.shift_reason: Optional[str] = None
        self.swap_shift_details: Optional[List[SwapShiftDetail]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ShiftGroupBuilder":
        return ShiftGroupBuilder()


class ShiftGroupBuilder(object):
    def __init__(self) -> None:
        self._shift_group = ShiftGroup()

    def type(self, type: str) -> "ShiftGroupBuilder":
        self._shift_group.type = type
        return self

    def instance_code(self, instance_code: str) -> "ShiftGroupBuilder":
        self._shift_group.instance_code = instance_code
        return self

    def user_id(self, user_id: str) -> "ShiftGroupBuilder":
        self._shift_group.user_id = user_id
        return self

    def swap_shift_user_id(self, swap_shift_user_id: str) -> "ShiftGroupBuilder":
        self._shift_group.swap_shift_user_id = swap_shift_user_id
        return self

    def start_time(self, start_time: int) -> "ShiftGroupBuilder":
        self._shift_group.start_time = start_time
        return self

    def end_time(self, end_time: int) -> "ShiftGroupBuilder":
        self._shift_group.end_time = end_time
        return self

    def shift_reason(self, shift_reason: str) -> "ShiftGroupBuilder":
        self._shift_group.shift_reason = shift_reason
        return self

    def swap_shift_details(self, swap_shift_details: List[SwapShiftDetail]) -> "ShiftGroupBuilder":
        self._shift_group.swap_shift_details = swap_shift_details
        return self

    def build(self) -> "ShiftGroup":
        return self._shift_group
