# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class SpecifiedRollback(object):
    _types = {
        "user_id": str,
        "task_id": int,
        "reason": str,
        "extra": str,
        "task_def_key_list": List[str],
    }

    def __init__(self, d=None):
        self.user_id: Optional[str] = None
        self.task_id: Optional[int] = None
        self.reason: Optional[str] = None
        self.extra: Optional[str] = None
        self.task_def_key_list: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SpecifiedRollbackBuilder":
        return SpecifiedRollbackBuilder()


class SpecifiedRollbackBuilder(object):
    def __init__(self) -> None:
        self._specified_rollback = SpecifiedRollback()

    def user_id(self, user_id: str) -> "SpecifiedRollbackBuilder":
        self._specified_rollback.user_id = user_id
        return self

    def task_id(self, task_id: int) -> "SpecifiedRollbackBuilder":
        self._specified_rollback.task_id = task_id
        return self

    def reason(self, reason: str) -> "SpecifiedRollbackBuilder":
        self._specified_rollback.reason = reason
        return self

    def extra(self, extra: str) -> "SpecifiedRollbackBuilder":
        self._specified_rollback.extra = extra
        return self

    def task_def_key_list(self, task_def_key_list: List[str]) -> "SpecifiedRollbackBuilder":
        self._specified_rollback.task_def_key_list = task_def_key_list
        return self

    def build(self) -> "SpecifiedRollback":
        return self._specified_rollback
