# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .specified_rollback import SpecifiedRollback


class SpecifiedRollbackInstanceRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[SpecifiedRollback] = None

    @staticmethod
    def builder() -> "SpecifiedRollbackInstanceRequestBuilder":
        return SpecifiedRollbackInstanceRequestBuilder()


class SpecifiedRollbackInstanceRequestBuilder(object):

    def __init__(self) -> None:
        specified_rollback_instance_request = SpecifiedRollbackInstanceRequest()
        specified_rollback_instance_request.http_method = HttpMethod.POST
        specified_rollback_instance_request.uri = "/open-apis/approval/v4/instances/specified_rollback"
        specified_rollback_instance_request.token_types = {AccessTokenType.TENANT}
        self._specified_rollback_instance_request: SpecifiedRollbackInstanceRequest = specified_rollback_instance_request

    def user_id_type(self, user_id_type: str) -> "SpecifiedRollbackInstanceRequestBuilder":
        self._specified_rollback_instance_request.user_id_type = user_id_type
        self._specified_rollback_instance_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: SpecifiedRollback) -> "SpecifiedRollbackInstanceRequestBuilder":
        self._specified_rollback_instance_request.request_body = request_body
        self._specified_rollback_instance_request.body = request_body
        return self

    def build(self) -> SpecifiedRollbackInstanceRequest:
        return self._specified_rollback_instance_request
