# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class SubscribeApprovalRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.approval_code: Optional[str] = None

    @staticmethod
    def builder() -> "SubscribeApprovalRequestBuilder":
        return SubscribeApprovalRequestBuilder()


class SubscribeApprovalRequestBuilder(object):

    def __init__(self) -> None:
        subscribe_approval_request = SubscribeApprovalRequest()
        subscribe_approval_request.http_method = HttpMethod.POST
        subscribe_approval_request.uri = "/open-apis/approval/v4/approvals/:approval_code/subscribe"
        subscribe_approval_request.token_types = {AccessTokenType.TENANT}
        self._subscribe_approval_request: SubscribeApprovalRequest = subscribe_approval_request

    def approval_code(self, approval_code: str) -> "SubscribeApprovalRequestBuilder":
        self._subscribe_approval_request.approval_code = approval_code
        self._subscribe_approval_request.paths["approval_code"] = str(approval_code)
        return self

    def build(self) -> SubscribeApprovalRequest:
        return self._subscribe_approval_request
