# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .task_urls import TaskUrls


class Task(object):
    _types = {
        "topic": int,
        "user_id": int,
        "title": str,
        "urls": TaskUrls,
        "process_external_id": str,
        "task_external_id": str,
        "status": str,
        "process_status": str,
        "definition_code": str,
        "initiators": List[str],
        "initiator_names": List[str],
        "task_id": int,
        "process_id": int,
        "process_code": str,
        "definition_group_id": int,
        "definition_group_name": str,
        "definition_id": int,
        "definition_name": str,
    }

    def __init__(self, d=None):
        self.topic: Optional[int] = None
        self.user_id: Optional[int] = None
        self.title: Optional[str] = None
        self.urls: Optional[TaskUrls] = None
        self.process_external_id: Optional[str] = None
        self.task_external_id: Optional[str] = None
        self.status: Optional[str] = None
        self.process_status: Optional[str] = None
        self.definition_code: Optional[str] = None
        self.initiators: Optional[List[str]] = None
        self.initiator_names: Optional[List[str]] = None
        self.task_id: Optional[int] = None
        self.process_id: Optional[int] = None
        self.process_code: Optional[str] = None
        self.definition_group_id: Optional[int] = None
        self.definition_group_name: Optional[str] = None
        self.definition_id: Optional[int] = None
        self.definition_name: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TaskBuilder":
        return TaskBuilder()


class TaskBuilder(object):
    def __init__(self) -> None:
        self._task = Task()

    def topic(self, topic: int) -> "TaskBuilder":
        self._task.topic = topic
        return self

    def user_id(self, user_id: int) -> "TaskBuilder":
        self._task.user_id = user_id
        return self

    def title(self, title: str) -> "TaskBuilder":
        self._task.title = title
        return self

    def urls(self, urls: TaskUrls) -> "TaskBuilder":
        self._task.urls = urls
        return self

    def process_external_id(self, process_external_id: str) -> "TaskBuilder":
        self._task.process_external_id = process_external_id
        return self

    def task_external_id(self, task_external_id: str) -> "TaskBuilder":
        self._task.task_external_id = task_external_id
        return self

    def status(self, status: str) -> "TaskBuilder":
        self._task.status = status
        return self

    def process_status(self, process_status: str) -> "TaskBuilder":
        self._task.process_status = process_status
        return self

    def definition_code(self, definition_code: str) -> "TaskBuilder":
        self._task.definition_code = definition_code
        return self

    def initiators(self, initiators: List[str]) -> "TaskBuilder":
        self._task.initiators = initiators
        return self

    def initiator_names(self, initiator_names: List[str]) -> "TaskBuilder":
        self._task.initiator_names = initiator_names
        return self

    def task_id(self, task_id: int) -> "TaskBuilder":
        self._task.task_id = task_id
        return self

    def process_id(self, process_id: int) -> "TaskBuilder":
        self._task.process_id = process_id
        return self

    def process_code(self, process_code: str) -> "TaskBuilder":
        self._task.process_code = process_code
        return self

    def definition_group_id(self, definition_group_id: int) -> "TaskBuilder":
        self._task.definition_group_id = definition_group_id
        return self

    def definition_group_name(self, definition_group_name: str) -> "TaskBuilder":
        self._task.definition_group_name = definition_group_name
        return self

    def definition_id(self, definition_id: int) -> "TaskBuilder":
        self._task.definition_id = definition_id
        return self

    def definition_name(self, definition_name: str) -> "TaskBuilder":
        self._task.definition_name = definition_name
        return self

    def build(self) -> "Task":
        return self._task
