# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .instance_search_approval import InstanceSearchApproval
from .instance_search_group import InstanceSearchGroup
from .instance_search_node import InstanceSearchNode
from .task_search_node import TaskSearchNode


class TaskSearchItem(object):
    _types = {
        "approval": InstanceSearchApproval,
        "group": InstanceSearchGroup,
        "instance": InstanceSearchNode,
        "task": TaskSearchNode,
    }

    def __init__(self, d=None):
        self.approval: Optional[InstanceSearchApproval] = None
        self.group: Optional[InstanceSearchGroup] = None
        self.instance: Optional[InstanceSearchNode] = None
        self.task: Optional[TaskSearchNode] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TaskSearchItemBuilder":
        return TaskSearchItemBuilder()


class TaskSearchItemBuilder(object):
    def __init__(self) -> None:
        self._task_search_item = TaskSearchItem()

    def approval(self, approval: InstanceSearchApproval) -> "TaskSearchItemBuilder":
        self._task_search_item.approval = approval
        return self

    def group(self, group: InstanceSearchGroup) -> "TaskSearchItemBuilder":
        self._task_search_item.group = group
        return self

    def instance(self, instance: InstanceSearchNode) -> "TaskSearchItemBuilder":
        self._task_search_item.instance = instance
        return self

    def task(self, task: TaskSearchNode) -> "TaskSearchItemBuilder":
        self._task_search_item.task = task
        return self

    def build(self) -> "TaskSearchItem":
        return self._task_search_item
