# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .instance_search_link import InstanceSearchLink


class TaskSearchNode(object):
    _types = {
        "user_id": str,
        "start_time": int,
        "end_time": int,
        "status": str,
        "title": str,
        "extra": str,
        "link": InstanceSearchLink,
        "task_id": str,
        "update_time": int,
        "task_external_id": str,
    }

    def __init__(self, d=None):
        self.user_id: Optional[str] = None
        self.start_time: Optional[int] = None
        self.end_time: Optional[int] = None
        self.status: Optional[str] = None
        self.title: Optional[str] = None
        self.extra: Optional[str] = None
        self.link: Optional[InstanceSearchLink] = None
        self.task_id: Optional[str] = None
        self.update_time: Optional[int] = None
        self.task_external_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TaskSearchNodeBuilder":
        return TaskSearchNodeBuilder()


class TaskSearchNodeBuilder(object):
    def __init__(self) -> None:
        self._task_search_node = TaskSearchNode()

    def user_id(self, user_id: str) -> "TaskSearchNodeBuilder":
        self._task_search_node.user_id = user_id
        return self

    def start_time(self, start_time: int) -> "TaskSearchNodeBuilder":
        self._task_search_node.start_time = start_time
        return self

    def end_time(self, end_time: int) -> "TaskSearchNodeBuilder":
        self._task_search_node.end_time = end_time
        return self

    def status(self, status: str) -> "TaskSearchNodeBuilder":
        self._task_search_node.status = status
        return self

    def title(self, title: str) -> "TaskSearchNodeBuilder":
        self._task_search_node.title = title
        return self

    def extra(self, extra: str) -> "TaskSearchNodeBuilder":
        self._task_search_node.extra = extra
        return self

    def link(self, link: InstanceSearchLink) -> "TaskSearchNodeBuilder":
        self._task_search_node.link = link
        return self

    def task_id(self, task_id: str) -> "TaskSearchNodeBuilder":
        self._task_search_node.task_id = task_id
        return self

    def update_time(self, update_time: int) -> "TaskSearchNodeBuilder":
        self._task_search_node.update_time = update_time
        return self

    def task_external_id(self, task_external_id: str) -> "TaskSearchNodeBuilder":
        self._task_search_node.task_external_id = task_external_id
        return self

    def build(self) -> "TaskSearchNode":
        return self._task_search_node
