# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .task_transfer import TaskTransfer


class TransferTaskRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[TaskTransfer] = None

    @staticmethod
    def builder() -> "TransferTaskRequestBuilder":
        return TransferTaskRequestBuilder()


class TransferTaskRequestBuilder(object):

    def __init__(self) -> None:
        transfer_task_request = TransferTaskRequest()
        transfer_task_request.http_method = HttpMethod.POST
        transfer_task_request.uri = "/open-apis/approval/v4/tasks/transfer"
        transfer_task_request.token_types = {AccessTokenType.TENANT}
        self._transfer_task_request: TransferTaskRequest = transfer_task_request

    def user_id_type(self, user_id_type: str) -> "TransferTaskRequestBuilder":
        self._transfer_task_request.user_id_type = user_id_type
        self._transfer_task_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: TaskTransfer) -> "TransferTaskRequestBuilder":
        self._transfer_task_request.request_body = request_body
        self._transfer_task_request.body = request_body
        return self

    def build(self) -> TransferTaskRequest:
        return self._transfer_task_request
