# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class TripGroupSchedule(object):
    _types = {
        "trip_start_time": str,
        "trip_end_time": str,
        "trip_interval": str,
        "departure": str,
        "destination": str,
        "transportation": str,
        "trip_type": str,
        "remark": str,
        "departure_id": str,
        "destination_ids": List[str],
    }

    def __init__(self, d=None):
        self.trip_start_time: Optional[str] = None
        self.trip_end_time: Optional[str] = None
        self.trip_interval: Optional[str] = None
        self.departure: Optional[str] = None
        self.destination: Optional[str] = None
        self.transportation: Optional[str] = None
        self.trip_type: Optional[str] = None
        self.remark: Optional[str] = None
        self.departure_id: Optional[str] = None
        self.destination_ids: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TripGroupScheduleBuilder":
        return TripGroupScheduleBuilder()


class TripGroupScheduleBuilder(object):
    def __init__(self) -> None:
        self._trip_group_schedule = TripGroupSchedule()

    def trip_start_time(self, trip_start_time: str) -> "TripGroupScheduleBuilder":
        self._trip_group_schedule.trip_start_time = trip_start_time
        return self

    def trip_end_time(self, trip_end_time: str) -> "TripGroupScheduleBuilder":
        self._trip_group_schedule.trip_end_time = trip_end_time
        return self

    def trip_interval(self, trip_interval: str) -> "TripGroupScheduleBuilder":
        self._trip_group_schedule.trip_interval = trip_interval
        return self

    def departure(self, departure: str) -> "TripGroupScheduleBuilder":
        self._trip_group_schedule.departure = departure
        return self

    def destination(self, destination: str) -> "TripGroupScheduleBuilder":
        self._trip_group_schedule.destination = destination
        return self

    def transportation(self, transportation: str) -> "TripGroupScheduleBuilder":
        self._trip_group_schedule.transportation = transportation
        return self

    def trip_type(self, trip_type: str) -> "TripGroupScheduleBuilder":
        self._trip_group_schedule.trip_type = trip_type
        return self

    def remark(self, remark: str) -> "TripGroupScheduleBuilder":
        self._trip_group_schedule.remark = remark
        return self

    def departure_id(self, departure_id: str) -> "TripGroupScheduleBuilder":
        self._trip_group_schedule.departure_id = departure_id
        return self

    def destination_ids(self, destination_ids: List[str]) -> "TripGroupScheduleBuilder":
        self._trip_group_schedule.destination_ids = destination_ids
        return self

    def build(self) -> "TripGroupSchedule":
        return self._trip_group_schedule
