# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class TrusteeshipInstanceCacheConfig(object):
    _types = {
        "form_policy": str,
        "form_vary_with_locale": bool,
        "form_version": int,
    }

    def __init__(self, d=None):
        self.form_policy: Optional[str] = None
        self.form_vary_with_locale: Optional[bool] = None
        self.form_version: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TrusteeshipInstanceCacheConfigBuilder":
        return TrusteeshipInstanceCacheConfigBuilder()


class TrusteeshipInstanceCacheConfigBuilder(object):
    def __init__(self) -> None:
        self._trusteeship_instance_cache_config = TrusteeshipInstanceCacheConfig()

    def form_policy(self, form_policy: str) -> "TrusteeshipInstanceCacheConfigBuilder":
        self._trusteeship_instance_cache_config.form_policy = form_policy
        return self

    def form_vary_with_locale(self, form_vary_with_locale: bool) -> "TrusteeshipInstanceCacheConfigBuilder":
        self._trusteeship_instance_cache_config.form_vary_with_locale = form_vary_with_locale
        return self

    def form_version(self, form_version: int) -> "TrusteeshipInstanceCacheConfigBuilder":
        self._trusteeship_instance_cache_config.form_version = form_version
        return self

    def build(self) -> "TrusteeshipInstanceCacheConfig":
        return self._trusteeship_instance_cache_config
