# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class TrusteeshipUrls(object):
    _types = {
        "form_detail_url": str,
        "action_definition_url": str,
        "approval_node_url": str,
        "action_callback_url": str,
        "pull_business_data_url": str,
    }

    def __init__(self, d=None):
        self.form_detail_url: Optional[str] = None
        self.action_definition_url: Optional[str] = None
        self.approval_node_url: Optional[str] = None
        self.action_callback_url: Optional[str] = None
        self.pull_business_data_url: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TrusteeshipUrlsBuilder":
        return TrusteeshipUrlsBuilder()


class TrusteeshipUrlsBuilder(object):
    def __init__(self) -> None:
        self._trusteeship_urls = TrusteeshipUrls()

    def form_detail_url(self, form_detail_url: str) -> "TrusteeshipUrlsBuilder":
        self._trusteeship_urls.form_detail_url = form_detail_url
        return self

    def action_definition_url(self, action_definition_url: str) -> "TrusteeshipUrlsBuilder":
        self._trusteeship_urls.action_definition_url = action_definition_url
        return self

    def approval_node_url(self, approval_node_url: str) -> "TrusteeshipUrlsBuilder":
        self._trusteeship_urls.approval_node_url = approval_node_url
        return self

    def action_callback_url(self, action_callback_url: str) -> "TrusteeshipUrlsBuilder":
        self._trusteeship_urls.action_callback_url = action_callback_url
        return self

    def pull_business_data_url(self, pull_business_data_url: str) -> "TrusteeshipUrlsBuilder":
        self._trusteeship_urls.pull_business_data_url = pull_business_data_url
        return self

    def build(self) -> "TrusteeshipUrls":
        return self._trusteeship_urls
