# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class UnsubscribeApprovalRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.approval_code: Optional[str] = None

    @staticmethod
    def builder() -> "UnsubscribeApprovalRequestBuilder":
        return UnsubscribeApprovalRequestBuilder()


class UnsubscribeApprovalRequestBuilder(object):

    def __init__(self) -> None:
        unsubscribe_approval_request = UnsubscribeApprovalRequest()
        unsubscribe_approval_request.http_method = HttpMethod.POST
        unsubscribe_approval_request.uri = "/open-apis/approval/v4/approvals/:approval_code/unsubscribe"
        unsubscribe_approval_request.token_types = {AccessTokenType.TENANT}
        self._unsubscribe_approval_request: UnsubscribeApprovalRequest = unsubscribe_approval_request

    def approval_code(self, approval_code: str) -> "UnsubscribeApprovalRequestBuilder":
        self._unsubscribe_approval_request.approval_code = approval_code
        self._unsubscribe_approval_request.paths["approval_code"] = str(approval_code)
        return self

    def build(self) -> UnsubscribeApprovalRequest:
        return self._unsubscribe_approval_request
