# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.check_external_instance_request import CheckExternalInstanceRequest
from ..model.check_external_instance_response import CheckExternalInstanceResponse
from ..model.create_external_instance_request import CreateExternalInstanceRequest
from ..model.create_external_instance_response import CreateExternalInstanceResponse


class ExternalInstance(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def check(self, request: CheckExternalInstanceRequest,
              option: Optional[RequestOption] = None) -> CheckExternalInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CheckExternalInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                 CheckExternalInstanceResponse)
        response.raw = resp

        return response

    async def acheck(self, request: CheckExternalInstanceRequest,
                     option: Optional[RequestOption] = None) -> CheckExternalInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CheckExternalInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                 CheckExternalInstanceResponse)
        response.raw = resp

        return response

    def create(self, request: CreateExternalInstanceRequest,
               option: Optional[RequestOption] = None) -> CreateExternalInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateExternalInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  CreateExternalInstanceResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateExternalInstanceRequest,
                      option: Optional[RequestOption] = None) -> CreateExternalInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateExternalInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  CreateExternalInstanceResponse)
        response.raw = resp

        return response
